\ Online help.

: help-breakpoints ( -- )
	." bc ( bpid -- ) Clear breakpoint."   cr
	." bd ( bpid -- ) Disable breakpoint." cr
	." be ( bpid -- ) Enable breakpoint."  cr
	." bl ( -- ) List breakpoints."        cr
	." bp ( addr -- ) Set a breakpoint."   cr
	." tc ( bpid -- ) Clear trap break."   cr
	." tl ( -- ) List trap breaks."        cr
	." tb ( addr -- ) Set a trap break."   cr ;

: help-execution ( -- )
	." go    ( -- ) Resume execution."                                                     cr
	." next  ( -- ) Step to the next instruction, over branches."                          cr
	." over  ( -- ) Step to the next instruction, over branches (corrected version)."      cr
	." nospy ( -- ) Remove any installed step-spy."                                        cr
	." out   ( -- ) Step out of the current routine."                                      cr
	." spy   ( addr value -- ) Install a step-spy for *addr == value."                     cr
	." step  ( -- ) Step to the next instruction, into branches."                          cr
	." to    ( addr -- ) Run to the specified address."                                    cr
	." wait  ( -- ) Wait for something to happen."                                         cr ;

: help-memory ( -- )
	." @byte ( addr -- n ) Fetch the  8-bit value at address." cr
	." @word ( addr -- n ) Fetch the 16-bit value at address." cr
	." @long ( addr -- n ) Fetch the 32-bit value at address." cr
	." !byte ( byte addr -- n ) Store the  8-bit value to address." cr
	." !word ( word addr -- n ) Store the 16-bit value to address." cr
	." !long ( long addr -- n ) Store the 32-bit value to address." cr
	." da  ( addr count -- ) Dump ASCII."                cr
	." db  ( addr count -- ) Dump bytes."                cr
	." dd  ( addr count -- ) Dump double-words (longs)." cr
	." dw  ( addr count -- ) Dump words."                cr
	." dis ( addr count -- ) Disassemble."               cr ;

: help-registers ( -- )
	." .d0 ( -- ) Display d0.   .a0 ( -- ) Display a0." cr
	." .d1 ( -- ) Display d1.   .a1 ( -- ) Display a1." cr
	." .d2 ( -- ) Display d2.   .a2 ( -- ) Display a2." cr
	." .d3 ( -- ) Display d3.   .a3 ( -- ) Display a3." cr
	." .d4 ( -- ) Display d4.   .a4 ( -- ) Display a4." cr
	." .d5 ( -- ) Display d5.   .a5 ( -- ) Display a5." cr
	." .d6 ( -- ) Display d6.   .a6 ( -- ) Display a6." cr
	." .d7 ( -- ) Display d7."                          cr
	." .ssp  ( -- ) Display ssp."           cr
	." .pc   ( -- ) Display pc."            cr
	." .sr   ( -- ) Display sr."            cr
	." .regs ( -- ) Display all registers." cr ;

: help-other ( -- )
	." bt ( -- ) Backtrace."                                  cr
	." ln ( addr -- ) Lookup the name for the given address." cr ;

: help ( -- )
	." Type 'bye' to exit."           cr
	." Breakpoints: help-breakpoints" cr
	." Execution:   help-execution"   cr
	." Memory:      help-memory"      cr
	." Registers:   help-registers"   cr
	." Other:       help-other"       cr ;
